//loop_intr.c Programma che usa gli interrupt con codec stereo PCM3003

#include <math.h>

float Fs = 44100.0;		//settaggio irrilevante se il jumper  in 3-4
					//sulla daughter card PCM3003
//PARAMETRI EFFETTO WAH
float damp = 0.05;			
int minf = 500;
int maxf = 3000;

float Fc = 500;
float delta = 0.1;

int Fw = 2000;
float Q1;
float pi = 3.14159;
float F1;

float yh_1, yb_1, yl_1;
float yh, yb, yl;

//SETTO LA FREQUENZA CENTRALE DEL PASSA BANDA
void setCutOffFreq() {
	if(Fc <= minf)
		delta = 0.1;
	else if(Fc >= maxf)
		delta = -0.1;
	
	Fc = Fc + delta;
}

//FUNZIONE EFFETTO WAH
short wah_wah(short sample) {

	yh = sample - yl_1 - Q1*yb_1;
	yb = F1*yh + yb_1;
	yl = F1*yb + yl_1;
	
	yh_1 = yh;
	yb_1 = yb;
	yl_1 = yl;
	
	setCutOffFreq();
	F1 = 2*sin(Fc*pi/Fs);
	

	
	return (short)(yb/2);
	
}

//INTERRUPT SERVICE ROUTINE
interrupt void c_int11()      
{     
	short wah_sample = wah_wah(input_left_sample());
	output_left_sample(wah_sample); //IN/OUT from left
   	
	return;			//return dall' interrupt
}

//MAIN
void main()
{           
	Q1 = damp*2;
	F1 = 2*sin(Fc*pi/Fs);
	yh_1 = yb_1 = yl_1 = 0;
	
                
	comm_intr();            //init DSK, codec, McBSP
  	while(1);               //loop infinito in attesa dell'interrupt
}
 
